package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Trigger extends Modifier {

	private static String xmlID = "TRIGGER";

	public Trigger(Element root) {
		super(root, Trigger.xmlID);
	}

	@Override
	public ArrayList<Adder> getAssignedAdders() {
		ArrayList<Adder> ret = super.getAssignedAdders();
		if ((parent == null)
				|| (GenericObject.findObjectByID(parent.getAssignedModifiers(),
						"FOCUS") != null)
				|| (GenericObject.findObjectByID(parent.getAssignedModifiers(),
						"CHARGES") != null)) {
			return ret;
		}
		if (GenericObject.findObjectByID(ret, "MULTIPLE") != null) {
			ret.remove(GenericObject.findObjectByID(ret, "MULTIPLE"));
		}
		return ret;
	}

	@Override
	public ArrayList<Adder> getAvailableAdders() {
		ArrayList<Adder> ret = (ArrayList<Adder>) super.getAvailableAdders()
				.clone();
		if ((parent == null)
				|| (GenericObject.findObjectByID(parent.getAssignedModifiers(),
						"FOCUS") != null)
				|| (GenericObject.findObjectByID(parent.getAssignedModifiers(),
						"CHARGES") != null)) {
			return ret;
		}
		if (GenericObject.findObjectByID(ret, "MULTIPLE") != null) {
			ret.remove(GenericObject.findObjectByID(ret, "MULTIPLE"));
		}
		return ret;
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		double val = getTotalValue();
		for (Adder ad : getAssignedAdders()) {
			if (adderString.length() > 0) {
				adderString += ", ";
			}
			if (ad.getSelectedOption() != null) {
				adderString += ad.getSelectedOption();
			} else {
				adderString += ad.getAlias();
			}
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += ":  ";
			}
			ret += getInput();
		}
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		ret += " (";
		if (adderString.trim().length() > 0) {
			ret += adderString + "; ";
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		ret += getFraction(val) + ")";
		return ret;
	}
}